#ifndef _IVENDOR_H
#define _IVENDOR_H



/*
 * vendor info format:
 *
 *  0       16 20  24                           88                    128     144 148 152                          216                  256
 *  -------------------------------------------------------------------------------------------------------------------------------------
 *  | Magic |id|len|          Data              |     reserve         | Magic |id|len|          Data               |     reserve        |
 *  -------------------------------------------------------------------------------------------------------------------------------------
 *  |<-                         section 0                           ->|<-                         section 1                           ->|
 */

 
// typedef enum
// {
//     SEC_SN = 0,
//     SEC_MAC,
//     SEC_DID,
//     SEC_KEY,
//     SEC_SSID,
//     SEC_RESERVE_0,
//     SEC_RESERVE_1,
//     SEC_RESERVE_2,
//     SEC_MAX_C
// } VendorBlock_e;




/*============================================
*function
*		打印Log 回调函数
*patamter:
* 		strMsg  信息
        nLevel  
				0 debug
				1 Info
				2 warning
				3 error
				4 fatal
*return :
*       0 成功
*		1 失败 
*=============================================
*/

typedef void(*lpLogFunc)(const int nLevel, const char *strMsg);
class IVendor
{
public:
	IVendor();
	virtual ~IVendor();
public:
/*============================================
*function
*		打开USB设备
*patamter:
* 		letter  盘符
*return :
*       0 成功
*		1 失败 
*=============================================
*/
	virtual int OpenDisk(char letter) ;

/*============================================
*function
*		关闭打开得设备
*patamter:
*
*return :
*		0 成
*       1 失败
*=============================================
*/
	virtual int CloseDisk();

/*============================================
*function
*		初始化设备
*patamter:
*       lpFunc 日志回调函数，自定义
*return :
*		0 成功
*       1 失败
*=============================================
*/
	virtual int Init(lpLogFunc lpFunc);
/*============================================
*function
*		读取数据
*patamter:
        id     VendorBlock_e 数值
*       data   1 个vendor info format
        len    128
*return :
*		0      成
*		1      失败
*=============================================
*/
	virtual int ReadVendorInfo(int id, char *data, int len);

/*============================================
*function
*		写入数据
*patamter:
        id     VendorBlock_e 数值
*       data   1 个vendor info format
        len    128
*return :
*		0      成功
*		1	   失败
*=============================================
*/
	virtual int WriteVendorInfo(int id, char *data, int len);

/*============================================
*function
*		擦除数据
*patamter:
        id     VendorBlock_e 数值
*return :
*		0 	   成功
*		1      失败
*=============================================
*/
	virtual int EraseVendorInfo(int id);


/*============================================
*function
*        运行命令
*					
*patamter:
*        cmd
*			运行命令，扩展使用
			如：
				setenv ota_upgrade_status 0  设置状态
				saveenv                      保存环境变量
				reset                        重启
		size 长度
*return :
*		0      成功
*		1      失败
*=============================================
*/
	virtual int RunCmd(char *cmd,int size);
	

/*============================================
*function
*		擦除数据
*patamter:
        clsid     1 目前
*return :
*		0          失败         
*=============================================
*/
	static IVendor* CreateObject(int clsid);


/*============================================
*function
*		擦除数据
*patamter:
        id     VendorBlock_e 数值
*return :
*           
*=============================================
*/
	static void     DestoryObject(IVendor *object);
};


#endif //_IVENDOR_H