/* Copyright (c) 2014-2019 WinnerHust
 * https://github.com/Winnerhust/inifile2
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef INIFILE_H_
#define INIFILE_H_

#include <vector>
#include <algorithm>
#include <string>
#include <string.h>

using std::string;
using std::vector;

#define RET_OK 0
// ûҵƥ]
#define ERR_UNMATCHED_BRACKETS 2
// Ϊ
#define ERR_SECTION_EMPTY 3
// Ѿ
#define ERR_SECTION_ALREADY_EXISTS 4
// key valueʧ
#define ERR_PARSE_KEY_VALUE_FAILED 5
// ļʧ
#define ERR_OPEN_FILE_FAILED 6
// ڴ治
#define ERR_NO_ENOUGH_MEMORY 7
// ûҵӦkey
#define ERR_NOT_FOUND_KEY 8
// ûҵӦsection
#define ERR_NOT_FOUND_SECTION 9

namespace inifile
{
	const char delim[] = "\n";
	struct IniItem {
		string key;
		string value;
		string comment;  // ÿעָͣϷ
		string rightComment;
	};

	struct IniSection {
		typedef vector<IniItem>::iterator IniItem_it;  // һָԪصָ
		IniItem_it begin() {
			return items.begin();  // νṹbeginԪָitemsͷָ
		}

		IniItem_it end() {
			return items.end();  // νṹbeginԪָitemsβָ
		}

		string name;
		string comment;  // ÿεעָͣϷ
		string rightComment;
		vector<IniItem> items;  // ֵ飬һοжֵvector
	};

	class IniFile
	{
	public:
		IniFile();
		~IniFile() {
			release();
		}

	public:
		/* 򿪲һΪfnameINIļ */
		int Load(const string &fname);
		/* ݱ浽ǰļ */
		int Save();
		/* 浽һΪfnameļ */
		int SaveAs(const string &fname);

		/* ȡsectionεһΪkeystringֵɹ0򷵻ش */
		int GetStringValue(const string &section, const string &key, string *value);
		/* ȡsectionεһΪkeyintֵɹ0򷵻ش */
		int GetIntValue(const string &section, const string &key, int *value);
		/* ȡsectionεһΪkeydoubleֵɹ0򷵻ش */
		int GetDoubleValue(const string &section, const string &key, double *value);
		/* ȡsectionεһΪkeyboolֵɹ0򷵻ش */
		int GetBoolValue(const string &section, const string &key, bool *value);
		/* ȡעͣkey=""ȡע */
		int GetComment(const string &section, const string &key, string *comment);
		/* ȡβעͣkey=""ȡεβע */
		int GetRightComment(const string &section, const string &key, string *rightComment);

		/* ȡsectionεһΪkeystringֵɹػȡֵ򷵻Ĭֵ */
		void GetStringValueOrDefault(const string &section, const string &key, string *value, const string &defaultValue);
		/* ȡsectionεһΪkeyintֵɹػȡֵ򷵻Ĭֵ */
		void GetIntValueOrDefault(const string &section, const string &key, int *value, int defaultValue);
		/* ȡsectionεһΪkeydoubleֵɹػȡֵ򷵻Ĭֵ */
		void GetDoubleValueOrDefault(const string &section, const string &key, double *value, double defaultValue);
		/* ȡsectionεһΪkeyboolֵɹػȡֵ򷵻Ĭֵ */
		void GetBoolValueOrDefault(const string &section, const string &key, bool *value, bool defaultValue);

		/* ȡsectionмΪkeyֵ,ֵvaluesvector */
		int GetValues(const string &section, const string &key, vector<string> *values);

		/* ȡsectionб,section */
		int GetSections(vector<string> *sections);
		/* ȡsectionٴһsection */
		int GetSectionNum();
		/* Ƿĳsection */
		bool HasSection(const string &section);
		/* ȡָsectionken=valueϢ */
		IniSection *getSection(const string &section = "");

		/* Ƿĳkey */
		bool HasKey(const string &section, const string &key);

		/* ֵַ */
		int SetStringValue(const string &section, const string &key, const string &value);
		/* ֵ */
		int SetIntValue(const string &section, const string &key, int value);
		/* øֵ */
		int SetDoubleValue(const string &section, const string &key, double value);
		/* òֵ */
		int SetBoolValue(const string &section, const string &key, bool value);
		/* עͣkey=""öע */
		int SetComment(const string &section, const string &key, const string &comment);
		/* βעͣkey=""öεβע */
		int SetRightComment(const string &section, const string &key, const string &rightComment);

		/* ɾ */
		void DeleteSection(const string &section);
		/* ɾضεض */
		void DeleteKey(const string &section, const string &key);
		/*עͷָĬΪ"#" */
		void SetCommentDelimiter(const string &delimiter);

		const string &GetErrMsg();
	private:
		/* ȡsectionмΪkeyֵ,ֵvaluesvector,,ע͸commentsvector */
		int GetValues(const string &section, const string &key, vector<string> *value, vector<string> *comments);

		/* ͬʱֵע */
		int setValue(const string &section, const string &key, const string &value, const string &comment = "");

		/* ȥstrǰcַ */
		static void trimleft(string &str, char c = ' ');
		/* ȥstrcַ */
		static void trimright(string &str, char c = ' ');
		/* ȥstrǰͺĿո,Tabȿհ׷ */
		static void trim(string &str);
		/* ַstrָdelimָɶӴ */
	private:
		int UpdateSection(const string &cleanLine, const string &comment,
			const string &rightComment, IniSection **section);
		int AddKeyValuePair(const string &cleanLine, const string &comment,
			const string &rightComment, IniSection *section);

		void release();
		bool split(const string &str, const string &sep, string *left, string *right);
		bool IsCommentLine(const string &str);
		bool parse(const string &content, string *key, string *value);
		// for debug
		void print();

	private:
		/* ȡsectionεһΪkeyֵ,ֵvalue */
		int getValue(const string &section, const string &key, string *value);
		/* ȡsectionεһΪkeyֵ,ֵvalue,ע͸comment */
		int getValue(const string &section, const string &key, string *value, string *comment);

		bool StringCmpIgnoreCase(const string &str1, const string &str2);
		bool StartWith(const string &str, const string &prefix);

	private:
		typedef vector<IniSection *>::iterator IniSection_it;
		vector<IniSection *> sections_vt;  // ڴ洢μϵvector
		string iniFilePath;
		string commentDelimiter;
		string errMsg;  // ʱĴϢ
	};

}  // endof namespace inifile

#endif  // INIFILE_H_

