﻿#pragma once
#include "USBhotplugDlg.h"
#include "WriteSetDlg.h"
#include "../vendorLib/IVendor.h"
#include "./inifile/inifile.h"

// WriteToolDlg 对话框


void DisplayLog(const int nLevel, const char *strMsg);
void LibLog(const int nLevel, const char *strMsg);
struct tagVendorData
{
	char magic[16];
	int id;
	int len;
	char data[64];
	char reserve[40];
};

class WriteToolDlg : public CDialogEx
{
	DECLARE_DYNAMIC(WriteToolDlg)

public:
	WriteToolDlg(CWnd* pParent = nullptr);   // 标准构造函数
	virtual ~WriteToolDlg();

// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_DIALOG_WRITE };
#endif
public:
	CString m_appTitle;
private:
	CUSBhotplugDlg m_hotplugDlg;
	WriteSetDlg  m_writeSetDlg;
	CListBox     m_output;
	HICON m_hIcon;
	CStatusBar m_statusBar;
    CString    m_disk; //盘符
	CString    m_magic;
	int        m_start;
	inifile::IniFile       m_iniConfig;
public:
	static WriteToolDlg*		m_instance;
	void  SetStatusBarText(int idx, CString strText);
	void  SetDiskLetter(CString strDisk) { m_disk = strDisk; };



	std::vector<int> m_EditDataIdList;
	std::vector<int> m_EditPrefixIdList;
	CString						m_appCurentDir;
	IVendor*                    m_vendorObject;
	std::vector<USBSetData>     m_usbDataList;
	

private:

	int UpgradeVendor(int eSetType, int opType);
	
	int AutoAdd(CString &strData, int add);

	void toVendorData(CString &strMagic, CString &strPrefix, CString &strData, int &eSetType, int &dataLength, tagVendorData &vendorData);
	void GetVendorData(CString &strMagic, CString &strPrefix, CString &strData, int eSetType, int &dataLength, tagVendorData &vendorData);

	int  CheckDataLength(USBSetData &usbSetData);
	int  CheckChangeEdit(int eSetType, CString& strData);
	void WriteToolDlg::OnEnChangeEdit(int eSetType);
	int UpgradeBase(int eSetType, int opType);

	void InitControl();
	int UpdateEditUI();
public:
	
	static WriteToolDlg * GetInstance() { return m_instance; };
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

	DECLARE_MESSAGE_MAP()
public:
	void Output(const char *strMsg);
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	LRESULT OnSetConfigChage(WPARAM wParam, LPARAM lParam);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	void    SetDialogTitle();
	bool    ReadResourceInformation(CString &sVersionNum);

	afx_msg void OnSetting();
	afx_msg void OnLog();
	afx_msg void OnAbout();
	afx_msg void OnBnClickedButtonRead();
	afx_msg void OnNMThemeChangedCheckAll(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedCheckAll();
	afx_msg void OnBnClickedButtonWrite();
	afx_msg void OnBnClickedButtonErase();


	afx_msg void OnEnChangeEditMagic();
	afx_msg void OnEnChangeEditSn();
	afx_msg void OnEnChangeEditMac();
	afx_msg void OnEnChangeEditDid();
	afx_msg void OnEnChangeEditKey();
	afx_msg void OnEnChangeEditSsid();
	afx_msg void OnEnChangeEditReserve0();
	afx_msg void OnEnChangeEditReserve1();
	afx_msg void OnEnChangeEditReserve2();
	afx_msg void OnBnClickedEditRest();
    afx_msg void OnBnClickedButtonEraseVendor();
};
