﻿// WriteToolDlg.cpp: 实现文件
//

#include "pch.h"
#include "resource.h"
#include "WriteToolDlg.h"
#include "afxdialogex.h"
#include "./Log/logger.h"
#pragma comment(lib,"Version.lib")


char gUsbSetTypeName[E_SEC_MAX_C][30] = {
	"SEC_SN",
	"SEC_MAC",
	"SEC_DID",
	"SEC_KEY",
	"SEC_SSID",
	"SEC_RESERVE_0",
	"SEC_RESERVE_1",
	"SEC_RESERVE_2",
};


void DisplayLog(const int nLevel, const char *strMsg)
{
	WriteToolDlg::GetInstance()->Output(strMsg);
}

void LibLog(const int nLevel, const char *strMsg)
{
	logger::record.writeLog((logger::Level)nLevel, strMsg);
}
int toInteger(char *str)
{
	int val = 0;
	val = atoi(str);
	return val;
}

// WriteToolDlg 对话框
WriteToolDlg* WriteToolDlg::m_instance = 0;
IMPLEMENT_DYNAMIC(WriteToolDlg, CDialogEx)

WriteToolDlg::WriteToolDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DIALOG_WRITE, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	char buf[MAX_PATH];
	GetModuleFileNameA(NULL,buf,MAX_PATH);
	PathRemoveFileSpec(buf);
	m_appCurentDir = buf;

	m_instance = this;
}

WriteToolDlg::~WriteToolDlg()
{

}

void WriteToolDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_output);
}


BEGIN_MESSAGE_MAP(WriteToolDlg, CDialogEx)
	ON_COMMAND(ID_32774, &WriteToolDlg::OnSetting)
	ON_COMMAND(ID_32775, &WriteToolDlg::OnLog)
	ON_COMMAND(ID_32776, &WriteToolDlg::OnAbout)
	ON_MESSAGE(WM_SELF_CONFG_CHAGE, OnSetConfigChage)
	ON_BN_CLICKED(IDC_BUTTON_READ, &WriteToolDlg::OnBnClickedButtonRead)
	ON_NOTIFY(NM_THEMECHANGED, IDC_CHECK_ALL, &WriteToolDlg::OnNMThemeChangedCheckAll)
	ON_BN_CLICKED(IDC_CHECK_ALL, &WriteToolDlg::OnBnClickedCheckAll)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, &WriteToolDlg::OnBnClickedButtonWrite)
	ON_BN_CLICKED(IDC_BUTTON_ERASE, &WriteToolDlg::OnBnClickedButtonErase)

	ON_EN_CHANGE(IDC_EDIT_MAGIC, &WriteToolDlg::OnEnChangeEditMagic)
	ON_EN_CHANGE(IDC_EDIT_SN, &WriteToolDlg::OnEnChangeEditSn)
	ON_EN_CHANGE(IDC_EDIT_MAC, &WriteToolDlg::OnEnChangeEditMac)
	ON_EN_CHANGE(IDC_EDIT_DID, &WriteToolDlg::OnEnChangeEditDid)
	ON_EN_CHANGE(IDC_EDIT_KEY, &WriteToolDlg::OnEnChangeEditKey)
	ON_EN_CHANGE(IDC_EDIT_SSID, &WriteToolDlg::OnEnChangeEditSsid)
	ON_EN_CHANGE(IDC_EDIT_RESERVE0, &WriteToolDlg::OnEnChangeEditReserve0)
	ON_EN_CHANGE(IDC_EDIT_RESERVE1, &WriteToolDlg::OnEnChangeEditReserve1)
	ON_EN_CHANGE(IDC_EDIT_RESERVE2, &WriteToolDlg::OnEnChangeEditReserve2)
	ON_BN_CLICKED(IDC_EDIT_REST, &WriteToolDlg::OnBnClickedEditRest)
    ON_BN_CLICKED(IDC_BUTTON_ERASE_VENDOR, &WriteToolDlg::OnBnClickedButtonEraseVendor)
END_MESSAGE_MAP()


// WriteToolDlg 消息处理程序


BOOL WriteToolDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	SetDialogTitle();
	
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	logger::record.setCbFunc(&DisplayLog);
	// TODO:  在此添加额外的初始化
	CMenu menu;
	menu.LoadMenuA(IDR_MENU2);
	SetMenu(&menu);
	m_start = 0;


	m_output.SetHorizontalExtent(1024);

	m_statusBar.Create(this);
	UINT nID[] = { 1001 };
	m_statusBar.SetIndicators(&nID[0], sizeof(nID) / sizeof(UINT));
	m_statusBar.SetPaneInfo(0, 1001, SBPS_STRETCH, 0);
	//设置状态栏位置
	RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 0);
	m_statusBar.SetPaneText(0, "设备连接: 无");

	
	m_usbDataList.resize(10);
	m_writeSetDlg.Create(IDD_DIALOG_SET,NULL);
	m_writeSetDlg.ShowWindow(SW_HIDE);

	m_hotplugDlg.Create(IDD_USBHOTPLUG_DIALOG, NULL);
	m_hotplugDlg.ShowWindow(SW_HIDE);

	m_vendorObject = IVendor::CreateObject(1);
	InitControl();

	m_vendorObject->Init(&LibLog);
	//CFont font;
	//font.CreatePointFont(120,"宋体");
	//m_output.SetFont(&font);

	//Output("===================================================12312313111111111111111111111111111111111=========");

	return TRUE;  // return TRUE unless you set the focus to a control
				  // 异常: OCX 属性页应返回 FALSE

}


void WriteToolDlg::OnOK()
{

}
void  WriteToolDlg::SetStatusBarText(int idx, CString strText)
{
	m_statusBar.SetPaneText(0, strText);
}


/*
*======================================================================================
*   write/read setting
*=======================================================================================
*/
void WriteToolDlg::OnSetting()
{
	// TODO: 在此添加命令处理程序代码
	if (m_writeSetDlg.IsWindowVisible() == false)
		m_writeSetDlg.ShowWindow(SW_SHOW);
}

/*
*======================================================================================
*   view log file
*=======================================================================================
*/
void WriteToolDlg::OnLog()
{
	// TODO: 在此添加命令处理程序代码
			//查看历史记录
	TCHAR szFilePath[MAX_PATH] = { 0 };
	GetModuleFileName(NULL, szFilePath, MAX_PATH);
	PathRemoveFileSpec(szFilePath);

	const struct tm *p = logger::record.getLocalTime();

	CString FileName;
	FileName.Format("log_%d_%d_%d.log", p->tm_year, p->tm_mon, p->tm_mday-1);
	CString strCMD = "/c start " + CString(szFilePath) + "\\Log\\" + FileName;
	//ShellExecuteA(this->m_hWnd, "open", "cmd.exe", strCMD, NULL, SW_HIDE);
	//ShellExecuteA(this->m_hWnd, "open", CString(szFilePath) + "\\Log\\" + FileName, 0, 0, 1);
	ShellExecute(this->m_hWnd, "explore", NULL, NULL, CString(szFilePath) + "\\Log\\", SW_SHOWMAXIMIZED);
}

/*
*======================================================================================
*   abount applicant
*=======================================================================================
*/
void WriteToolDlg::OnAbout()
{
	// TODO: 在此添加命令处理程序代码
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}


void WriteToolDlg::OnBnClickedButtonRead()
{
	// TODO: 在此添加控件通知处理程序代码

	if (m_disk.GetLength() == 0)
	{
		logger::record.writeLog(logger::Level::Debug, "无识别到设备连接，读取失败！");
		return;
	}

    if (m_start == 1)
    {
        MessageBox("正在读取!", 0, MB_OK);
        return;
    }


	if (m_vendorObject->OpenDisk(m_disk.GetAt(0)) != 0 )
	{
		logger::record.writeLog(logger::Level::Debug, "打开设备失败，读取失败！");
		return ;
	}
	GetDlgItem(IDC_BUTTON_READ)->EnableWindow(false);
	m_start = 1;
	int check;
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_SN))->GetCheck())
	{
		UpgradeVendor(E_SEC_SN,E_OP_READ);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_MAC))->GetCheck())
	{
		UpgradeVendor(E_SEC_MAC, E_OP_READ);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_DID))->GetCheck())
	{
		UpgradeVendor(E_SEC_DID, E_OP_READ);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_KEY))->GetCheck())
	{
		UpgradeVendor(E_SEC_KEY, E_OP_READ);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_SSID))->GetCheck())
	{
		UpgradeVendor(E_SEC_SSID, E_OP_READ);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE0))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_0, E_OP_READ);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE1))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_1, E_OP_READ);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE2))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_2, E_OP_READ);
	}


	m_vendorObject->CloseDisk();
	m_start = 0;
	GetDlgItem(IDC_BUTTON_READ)->EnableWindow(true);
}

void WriteToolDlg::OnBnClickedButtonWrite()
{
	// TODO: 在此添加控件通知处理程序代码
	if (m_disk.GetLength() == 0)
	{
		logger::record.writeLog(logger::Level::Debug, "无识别到设备连接，读取失败！");
		return;
	}


	if (m_vendorObject->OpenDisk(m_disk.GetAt(0)) != 0)
	{
		logger::record.writeLog(logger::Level::Debug, "打开设备失败，读取失败！");
		return;
	}
	if (m_start == 1)
	{
		MessageBox("正在写入!", 0, MB_OK);
		return;
	}

	GetDlgItem(IDC_BUTTON_WRITE)->EnableWindow(false);
	m_start = 1;

	// TODO: 在此添加控件通知处理程序代码
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_SN))->GetCheck())
	{
		UpgradeVendor(E_SEC_SN, E_OP_WRITE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_MAC))->GetCheck())
	{
		UpgradeVendor(E_SEC_MAC, E_OP_WRITE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_DID))->GetCheck())
	{
		UpgradeVendor(E_SEC_DID, E_OP_WRITE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_KEY))->GetCheck())
	{
		UpgradeVendor(E_SEC_KEY, E_OP_WRITE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_SSID))->GetCheck())
	{
		UpgradeVendor(E_SEC_SSID, E_OP_WRITE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE0))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_0, E_OP_WRITE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE1))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_1, E_OP_WRITE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE2))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_2, E_OP_WRITE);
	}

	m_vendorObject->CloseDisk();
	m_start = 0;
	GetDlgItem(IDC_BUTTON_WRITE)->EnableWindow(true);
}


void WriteToolDlg::OnBnClickedButtonErase()
{
	if (m_disk.GetLength() == 0)
	{
		logger::record.writeLog(logger::Level::Debug, "无识别到设备连接，读取失败！");
		return;
	}

	
	if (m_vendorObject->OpenDisk(m_disk.GetAt(0)) != 0)
	{
		logger::record.writeLog(logger::Level::Debug, "打开设备失败，读取失败！");
		return;
	}
	if (m_start == 1)
	{
		MessageBox("正在擦除!", 0, MB_OK);
		return;
	}

	GetDlgItem(IDC_BUTTON_ERASE)->EnableWindow(false);
	m_start = 1;
	int check;
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_SN))->GetCheck())
	{
		UpgradeVendor(E_SEC_SN, E_OP_ERASE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_MAC))->GetCheck())
	{
		UpgradeVendor(E_SEC_MAC, E_OP_ERASE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_DID))->GetCheck())
	{
		UpgradeVendor(E_SEC_DID, E_OP_ERASE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_KEY))->GetCheck())
	{
		UpgradeVendor(E_SEC_KEY, E_OP_ERASE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_SSID))->GetCheck())
	{
		UpgradeVendor(E_SEC_SSID, E_OP_ERASE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE0))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_0, E_OP_ERASE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE1))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_1, E_OP_ERASE);
	}
	if (1 == ((CButton*)GetDlgItem(IDC_CHECK_RESERVE2))->GetCheck())
	{
		UpgradeVendor(E_SEC_RESERVE_2, E_OP_ERASE);
	}


	m_vendorObject->CloseDisk();
	m_start = 0;
	GetDlgItem(IDC_BUTTON_ERASE)->EnableWindow(true);
}


void WriteToolDlg::OnBnClickedEditRest()
{
	// TODO: 在此添加控件通知处理程序代码
	if (m_disk.GetLength() == 0)
	{
		logger::record.writeLog(logger::Level::Debug, "无识别到设备连接，读取失败！");
		return;
	}

    if (m_start == 1)
    {
        MessageBox("正在REST!", 0, MB_OK);
        return;
    }

	if (m_vendorObject->OpenDisk(m_disk.GetAt(0)) != 0)
	{
		logger::record.writeLog(logger::Level::Debug, "打开设备失败，读取失败！");
		return;
	}

	GetDlgItem(IDC_EDIT_REST)->EnableWindow(false);
	m_start = 1;
	

	char cmd[1024];
	sprintf(cmd, "setenv ota_upgrade_status 0");
	if (m_vendorObject->RunCmd(cmd, strlen(cmd)) != 0)
	{
		logger::record.writeLog(logger::Level::Debug, "setenv ota_upgrade_status 0 操作失败！");
		goto reset_end;
	}

	sprintf(cmd, "saveenv");
	if (m_vendorObject->RunCmd(cmd, strlen(cmd)) != 0)
	{
		logger::record.writeLog(logger::Level::Debug, "saveenv  操作失败！");
		goto reset_end;
	}

	sprintf(cmd, "reset");
	if (m_vendorObject->RunCmd(cmd, strlen(cmd)) != 0)
	{
		logger::record.writeLog(logger::Level::Debug, "reset  操作失败！");
		goto reset_end;
	}

reset_end:
	m_start = 0;
	m_vendorObject->CloseDisk();
	GetDlgItem(IDC_EDIT_REST)->EnableWindow(true);
}

void WriteToolDlg::OnBnClickedButtonEraseVendor()
{
    // TODO: 在此添加控件通知处理程序代码
    CString strMsg;
    int ret;


    if (m_disk.GetLength() == 0)
    {
        logger::record.writeLog(logger::Level::Debug, "无识别到设备连接，读取失败！");
        return;
    }

    if (m_start == 1)
    {
        MessageBox("正在擦除!", 0, MB_OK);
        return;
    }

    if (m_vendorObject->OpenDisk(m_disk.GetAt(0)) != 0)
    {
        logger::record.writeLog(logger::Level::Debug, "打开设备失败，读取失败！");
        return;
    }

    m_start = 1;

    ret = m_vendorObject->EraseVendorInfo(-1);
    if (ret != 0)
    {
        strMsg.Format("擦除分区失败!");
        logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());

    }
    else
    {
        strMsg.Format("擦除分区擦除成功!");
        logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
    }

    m_start = 0;
    m_vendorObject->CloseDisk();
}


void WriteToolDlg::OnNMThemeChangedCheckAll(NMHDR *pNMHDR, LRESULT *pResult)
{
	// 该功能要求使用 Windows XP 或更高版本。
	// 符号 _WIN32_WINNT 必须 >= 0x0501。
	// TODO: 在此添加控件通知处理程序代码
	*pResult = 0;
}


void WriteToolDlg::OnBnClickedCheckAll()
{
	// TODO: 在此添加控件通知处理程序代码
	CButton*bt = (CButton*)GetDlgItem(IDC_CHECK_ALL);
	int check  = bt->GetCheck();

	((CButton*)GetDlgItem(IDC_CHECK_SN))->SetCheck(check);
	((CButton*)GetDlgItem(IDC_CHECK_MAC))->SetCheck(check);
	((CButton*)GetDlgItem(IDC_CHECK_DID))->SetCheck(check);
	((CButton*)GetDlgItem(IDC_CHECK_KEY))->SetCheck(check);
	((CButton*)GetDlgItem(IDC_CHECK_SSID))->SetCheck(check);
	((CButton*)GetDlgItem(IDC_CHECK_RESERVE0))->SetCheck(check);
	((CButton*)GetDlgItem(IDC_CHECK_RESERVE1))->SetCheck(check);
	((CButton*)GetDlgItem(IDC_CHECK_RESERVE2))->SetCheck(check);
}


int WriteToolDlg::AutoAdd(CString &strData, int add)
{
	if (add == 0)
		return 0;

	int len = strData.GetLength();
	int val;
	int i;

	int addVal = add;


	for (i = len - 1; i >= 0; i--)
	{
		addVal = strData.GetAt(i) - '0'  + addVal;
		val = addVal % 10;
		addVal = addVal/10;


		val = '0' + val;
		strData.SetAt(i, val);
		if (addVal == 0)
		{
			break;
		}
	}

	if (i == -1)
	{
		CString strMsg;
		if (addVal != 0)
		{
			strMsg.Format("%d", addVal);
		}
		strData = strMsg + strData;
	}
	return 0;
}

void WriteToolDlg::toVendorData(CString &strMagic, CString &strPrefix, CString &strData, int &eSetType, int &dataLength, tagVendorData &vendorData)
{
	CString data = strPrefix + strData;
	int len1 = strMagic.GetLength();
	len1 = min(len1, 16);

	vendorData.len = dataLength;
	vendorData.id = eSetType;
	int len2 = data.GetLength();
	len2 = min(len2, 64);
	len2 = min(len2, dataLength);
	len2 = min(len2, vendorData.len);

	memcpy(vendorData.magic, strMagic.GetBuffer(), len1);
	memcpy(vendorData.data, data.GetBuffer(), len2);
	vendorData.len = len2;
}

void WriteToolDlg::GetVendorData(CString &strMagic, CString &strPrefix, CString &strData, int eSetType, int &dataLength, tagVendorData &vendorData)
{
	eSetType = vendorData.id;
	dataLength = vendorData.len;

	char s_magic[60] = { 0 };
	char s_data[120] = { 0 };
	memcpy(s_magic, vendorData.magic, 16);
	memcpy(s_data, vendorData.data, 64);
	strMagic = s_magic;
	strData = s_data;
	strPrefix = "";

	int curIndx = -1;
	for (int i = 0; i < strData.GetLength(); i++)
	{
		if (strData.GetAt(i) <= '9')
		{
			curIndx = i;
			break;
		}
	}

	if (curIndx != -1)
	{
		strPrefix = strData.Left(curIndx);
		strData = strData.Mid(curIndx);
	}
	else
	{
		strPrefix = "";
	}
}




int WriteToolDlg::UpgradeBase(int eSetType,int opType)
{

	CString strMagic = m_magic;
	CString strData  = m_usbDataList[eSetType].data;
	CString strPrefix = m_usbDataList[eSetType].prefix;




	tagVendorData vendorData;
	memset(&vendorData, 0, sizeof(vendorData));

	int ret = 0;
	int len = 0;
	CString strMsg;

	if (opType == E_OP_READ)
	{
		ret = m_vendorObject->ReadVendorInfo(eSetType, (char*)&vendorData, 128);
		if (ret !=  0)
		{
			strMsg.Format("[%s] 读取失败!", gUsbSetTypeName[eSetType]);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
			return -1;
		}
		int typeTmpe = 0;
		GetVendorData(strMagic,strPrefix, strData, typeTmpe, len, vendorData);
		
		if (strMagic != m_magic)
		{
			strMsg.Format("[%s] magic 数据匹配不上!", gUsbSetTypeName[eSetType]);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
		}

		char a = 255;
		if (strMagic.GetAt(0) == a && strMagic.GetAt(1) == a)
		{
			strMsg.Format("[%s] 无效数据: magic:%s  data:%s%s ", gUsbSetTypeName[eSetType],
				strMagic, strPrefix, strData);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
			return -1;
		}
		else
		{
			strMsg.Format("[%s] 读取数据: magic:%s  data:%s%s ", gUsbSetTypeName[eSetType], 
					strMagic, strPrefix, strData);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
		}
	}
	else if (opType == E_OP_WRITE)
	{
	
		int len = toInteger(m_usbDataList[eSetType].dataLength.GetBuffer());
        int nlen = strData.GetLength() + strPrefix.GetLength();
        if (len != nlen)
        {
            strMsg.Format("[%s] 写入被阻断，长度(%d)不等于设置的长度(%d)!", gUsbSetTypeName[eSetType],nlen, len);
            logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
            return -1;
        }

		toVendorData(strMagic,strPrefix, strData, eSetType, len, vendorData);
		ret = m_vendorObject->WriteVendorInfo(eSetType, (char*)&vendorData, 128);
		if (ret != 0)
		{
			strMsg.Format("[%s] 写入失败!", gUsbSetTypeName[eSetType]);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
			return -1;
		}
		else
		{
			strMsg.Format("[%s] 写入成功!",  gUsbSetTypeName[eSetType]);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
		}

		int add = toInteger(m_usbDataList[eSetType].addMode.GetBuffer());
		AutoAdd(strData, add);
		m_usbDataList[eSetType].data = strData;
		GetDlgItem(m_EditDataIdList[eSetType] )->SetWindowText(m_usbDataList[eSetType].data);

	}
	else if (opType == E_OP_ERASE)
	{
		ret = m_vendorObject->EraseVendorInfo(eSetType);
		if (ret!= 0)
		{
			strMsg.Format("[%s] 擦除失败!",  gUsbSetTypeName[eSetType]);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());

		}
		else
		{
			strMsg.Format("[%s] 擦除成功!",  gUsbSetTypeName[eSetType]);
			logger::record.writeLog(logger::Level::Debug, strMsg.GetBuffer());
		}
	}

	return 0;
}



int WriteToolDlg::UpgradeVendor(int eSetType, int opType)
{
	int ret = -1;
	switch (eSetType)
	{
	case E_SEC_SN:
		ret = UpgradeBase(E_SEC_SN,opType);
		break;
	case E_SEC_MAC:
		ret = UpgradeBase(E_SEC_MAC, opType);
		break;
	case E_SEC_DID:
		ret = UpgradeBase(E_SEC_DID, opType);
		break;
	case E_SEC_KEY:
		ret = UpgradeBase(E_SEC_KEY, opType);
		break;
	case E_SEC_SSID:
		ret = UpgradeBase(E_SEC_SSID, opType);
		break;
	case E_SEC_RESERVE_0:
		ret = UpgradeBase(E_SEC_RESERVE_0, opType);
		break;
	case E_SEC_RESERVE_1:
		ret = UpgradeBase(E_SEC_RESERVE_1, opType);
		break;
	case E_SEC_RESERVE_2:
		ret = UpgradeBase(E_SEC_RESERVE_2, opType);
		break;
	}
	return 0;
}


int WriteToolDlg::UpdateEditUI()
{
	
}




int WriteToolDlg::CheckDataLength(USBSetData &usbSetData)
{
	int len = atoi(usbSetData.dataLength.GetBuffer());
	if (usbSetData.prefix.GetLength() + usbSetData.data.GetLength() > len)
	{
		return -1;
	}
	return 0;
}



LRESULT WriteToolDlg::OnSetConfigChage(WPARAM wParam, LPARAM lParam)
{
	CString strMsg;
	//SN
	for (int i = 0; i < E_SEC_MAX_C; i++)
	{
		m_writeSetDlg.GetSetConfigData(i, m_usbDataList[i]);
		if (CheckDataLength(m_usbDataList[i]) == -1)
		{
			int dataLength = toInteger(m_usbDataList[i].dataLength.GetBuffer());
			int len = m_usbDataList[i].data.GetLength() + m_usbDataList[i].prefix.GetLength();

			strMsg.Format(" [%s] 数据大于配置的数据大小，写入会被截断(%d >  %d)", gUsbSetTypeName[i],  len, dataLength);
			logger::record.writeLog(logger::Level::Warning, strMsg.GetBuffer());
		}
	}
    USBSetCommonData commonData;
    m_writeSetDlg.GetSetCommonConfigData(commonData);
    m_magic = commonData.magic;
    GetDlgItem(IDC_EDIT_MAGIC)->SetWindowText(m_magic);

	for (int i = 0; i < E_SEC_MAX_C; i++)
	{
		GetDlgItem(m_EditPrefixIdList[i])->SetWindowText(m_usbDataList[i].prefix);
	}


	return S_OK;
}

void WriteToolDlg::InitControl()
{
	m_EditDataIdList.push_back(IDC_EDIT_SN);
	m_EditDataIdList.push_back(IDC_EDIT_MAC);
	m_EditDataIdList.push_back(IDC_EDIT_DID);
	m_EditDataIdList.push_back(IDC_EDIT_KEY);
	m_EditDataIdList.push_back(IDC_EDIT_SSID);
	m_EditDataIdList.push_back(IDC_EDIT_RESERVE0);
	m_EditDataIdList.push_back(IDC_EDIT_RESERVE1);
	m_EditDataIdList.push_back(IDC_EDIT_RESERVE2);

	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_SN);
	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_MAC);
	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_DID);
	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_KEY);
	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_SSID);
	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_RESERVE0);
	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_RESERVE1);
	m_EditPrefixIdList.push_back(IDC_EDIT_PREFIX_RESERVE2);

	OnSetConfigChage(0,0);

}

void WriteToolDlg::Output(const char *strMsg)
{
	OutputDebugString(strMsg);
	OutputDebugString("\n");

	int curidx = m_output.GetCount();
	m_output.InsertString(curidx, strMsg);
	m_output.SetCurSel(curidx);

}

void WriteToolDlg::OnEnChangeEditMagic()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
}

int WriteToolDlg::CheckChangeEdit(int eSetType, CString& strData)
{
	CString strValue = strData;
	int maxLen = atoi(m_usbDataList[eSetType].dataLength.GetBuffer());
	int prefixLen = m_usbDataList[eSetType].prefix.GetLength();

	if (strValue.GetLength() == 0)
		return 0;

	if (strValue.GetLength() + prefixLen > maxLen)
	{
		
		int curLen = maxLen - prefixLen;
		if (curLen < 0)
			strData = "";
		else
			strData = strData.Left(curLen);

		CString strMsg;
		strMsg.Format("[%s] 数据最大长度不能超过 %d。", gUsbSetTypeName[eSetType], maxLen);
		MessageBox(strMsg, "提示", MB_OK);
		return -1;
		
	}

	return 0;
}
void WriteToolDlg::OnEnChangeEdit(int eSetType)
{
	CString strValue;
	GetDlgItem(m_EditDataIdList[eSetType])->GetWindowText(strValue);
	if (CheckChangeEdit(eSetType, strValue) == -1)
	{
		m_usbDataList[eSetType].data = strValue;
		GetDlgItem(m_EditDataIdList[eSetType])->SetWindowText(strValue);
	}
	else
	{
		m_usbDataList[eSetType].data = strValue;
	}
}

void WriteToolDlg::OnEnChangeEditSn()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_SN;
	OnEnChangeEdit(eSetType);
}



void WriteToolDlg::OnEnChangeEditMac()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_MAC;
	OnEnChangeEdit(eSetType);
}




void WriteToolDlg::OnEnChangeEditDid()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_DID;
	OnEnChangeEdit(eSetType);
}


void WriteToolDlg::OnEnChangeEditKey()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_KEY;
	OnEnChangeEdit(eSetType);
}


void WriteToolDlg::OnEnChangeEditSsid()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_SSID;
	OnEnChangeEdit(eSetType);

}


void WriteToolDlg::OnEnChangeEditReserve0()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_RESERVE_0;
	OnEnChangeEdit(eSetType);
}


void WriteToolDlg::OnEnChangeEditReserve1()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_RESERVE_1;
	OnEnChangeEdit(eSetType);

}


void WriteToolDlg::OnEnChangeEditReserve2()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	int eSetType = E_SEC_RESERVE_2;
	OnEnChangeEdit(eSetType);

}

LRESULT WriteToolDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	//switch (message)
	//{
	//case WM_DEVICECHANGE:
	//	break;
	//case WM_LBUTTONDOWN:
	//	return;
	//}

	return CWnd::WindowProc(message, wParam, lParam);
}


bool WriteToolDlg::ReadResourceInformation(CString &sVersionNum)
{
	DWORD dwLength, dwNullHandle;
	char szFileName[1024];

	dwLength = ::GetModuleFileName(AfxGetInstanceHandle(), szFileName, sizeof(szFileName));
	dwLength = ::GetFileVersionInfoSize(szFileName, &dwNullHandle);

	char* pVersionInfo = new char[dwLength];
	::GetFileVersionInfo(szFileName, NULL, dwLength, pVersionInfo);

	unsigned int  cbTranslate = 0;
	struct LANGANDCODEPAGE {
		WORD wLanguage;
		WORD wCodePage;
	} *lpTranslate;
	::VerQueryValue(pVersionInfo, "\\VarFileInfo\\Translation", (LPVOID *)&lpTranslate, &cbTranslate);

	char  SubBlock[200];
	sprintf(SubBlock, "\\StringFileInfo\\%04x%04x\\ProductVersion", lpTranslate[0].wLanguage, lpTranslate[0].wCodePage);
	void *lpBuffer = NULL;
	unsigned int dwBytes = 0;
	VerQueryValue(pVersionInfo, SubBlock, &lpBuffer, &dwBytes);

	sVersionNum.Format("%s", (char *)lpBuffer);

	delete[] pVersionInfo;

	return   TRUE;
}

//设置窗口标题
void WriteToolDlg::SetDialogTitle()
{
	CString sVersion;
	ReadResourceInformation(sVersion);

	sVersion.Remove(' ');

	// 解析获取到的版本信息
	int nVersion[4];

	int nVersionIndex = 0;
	CString sVersionTemp;
	while (AfxExtractSubString(sVersionTemp, sVersion, nVersionIndex, '.'))
	{
		nVersion[nVersionIndex] = atoi(sVersionTemp.GetBuffer(0));
		nVersionIndex++;
		if (nVersionIndex >= 4)
		{
			break;
		}
	}

	char sWindowTitle[64];
	sprintf(sWindowTitle, "USB Write SN Tool V%d.%d.%d.%d", nVersion[0], nVersion[1], nVersion[2], nVersion[3]);
	m_appTitle = sWindowTitle;
	// 设置标题栏
	SetWindowText(sWindowTitle);
}

