﻿#pragma once
#include "Config.h"
#include "./inifile/inifile.h"

// WriteSetTabDlg 对话框
struct USBSetData
{
	CString magic;
	CString prefix;
	CString addMode;

	CString data;
	CString dataLength;
};



class WriteSetTabDlg : public CDialogEx
{
	DECLARE_DYNAMIC(WriteSetTabDlg)

public:
	WriteSetTabDlg(CWnd* pParent = nullptr);   // 标准构造函数
	virtual ~WriteSetTabDlg();
	void Init(ENUM_SET_TYPE eSetType);

private:
	ENUM_SET_TYPE m_eSetType;
	inifile::IniFile       m_iniConfig;


// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_DIALOG_TAB_SET };
#endif
public:
	CString       m_magic;
	CString       m_dataLength;
	CString       m_prefix;
	CString       m_addMode;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

	DECLARE_MESSAGE_MAP()
public:
	void         GetSetConfigData(USBSetData & usbData);
	void         SaveConfig();
	int		 UpdateData();
	int      SetData();
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnEnChangeEditPrefix();
	afx_msg void OnEnChangeEditDataLenght();
	afx_msg void OnEnChangeEditAdd();
};
