﻿// WriteSetTabDlg.cpp: 实现文件
//

#include "pch.h"
#include "resource.h"
#include "WriteSetTabDlg.h"
#include "afxdialogex.h"


// WriteSetTabDlg 对话框

IMPLEMENT_DYNAMIC(WriteSetTabDlg, CDialogEx)

WriteSetTabDlg::WriteSetTabDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DIALOG_TAB_SET, pParent)
{

}

WriteSetTabDlg::~WriteSetTabDlg()
{
}

void WriteSetTabDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(WriteSetTabDlg, CDialogEx)
	ON_EN_CHANGE(IDC_EDIT_PREFIX, &WriteSetTabDlg::OnEnChangeEditPrefix)
	ON_EN_CHANGE(IDC_EDIT_DATA_LENGHT, &WriteSetTabDlg::OnEnChangeEditDataLenght)
	ON_EN_CHANGE(IDC_EDIT_ADD, &WriteSetTabDlg::OnEnChangeEditAdd)
END_MESSAGE_MAP()


// WriteSetTabDlg 消息处理程序
void WriteSetTabDlg::Init(ENUM_SET_TYPE eSetType)
{ 
	m_eSetType = eSetType;
	char path[MAX_PATH];
	GetModuleFileName(0, path, MAX_PATH);
	PathRemoveFileSpec(path);
	std::string fileName;

	switch (m_eSetType)
	{
	case E_SEC_SN:
		fileName = "SN.ini";
		break;
	case E_SEC_MAC:
		fileName = "MAC.ini";
		break;
	case E_SEC_DID:
		fileName = "DID.ini";
		break;
	case E_SEC_KEY:
		fileName = "KEY.ini";
		break;
	case E_SEC_SSID:
		fileName = "SSID.ini";
		break;
	case E_SEC_RESERVE_0:
		fileName = "RESERVE_0.ini";
		break;
	case E_SEC_RESERVE_1:
		fileName = "RESERVE_1.ini";
		break;
	case E_SEC_RESERVE_2:
		fileName = "RESERVE_2.ini";
		break;
	}

	m_iniConfig.Load(std::string(path) + "\\Config\\" + fileName);
	
	std::string strValue;
	//m_iniConfig.GetStringValue("vendor", "magic",&strValue);
	//m_magic = strValue.c_str();

	m_iniConfig.GetStringValue("vendor", "dataLength", &strValue);
	m_dataLength = strValue.c_str();

	m_iniConfig.GetStringValue("vendor", "prefix", &strValue);
	m_prefix = strValue.c_str();

	m_iniConfig.GetStringValue("vendor", "addMode", &strValue);
	m_addMode = strValue.c_str();

	//GetDlgItem(IDC_EDIT_MAGIC)->SetWindowText(m_magic);
	GetDlgItem(IDC_EDIT_DATA_LENGHT)->SetWindowText(m_dataLength);
	GetDlgItem(IDC_EDIT_ADD)->SetWindowText(m_addMode);
	GetDlgItem(IDC_EDIT_PREFIX)->SetWindowText(m_prefix);
}

BOOL WriteSetTabDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  在此添加额外的初始化

	return TRUE;  // return TRUE unless you set the focus to a control
				  // 异常: OCX 属性页应返回 FALSE
}

void WriteSetTabDlg::GetSetConfigData(USBSetData &usbData)
{
	//usbData.magic = m_magic;
	usbData.dataLength = m_dataLength;
	usbData.prefix = m_prefix;
	usbData.addMode = m_addMode;
}

int WriteSetTabDlg::UpdateData()
{
	//GetDlgItem(IDC_EDIT_MAGIC)->GetWindowText(m_magic);
	CString dataLength;
	CString addMode;
	CString prefix;
	
	GetDlgItem(IDC_EDIT_DATA_LENGHT)->GetWindowText(dataLength);
	GetDlgItem(IDC_EDIT_ADD)->GetWindowText(addMode);
	GetDlgItem(IDC_EDIT_PREFIX)->GetWindowText(prefix);

	//check add Mode
	int value = atoi(addMode.GetBuffer());
	if (value > 9)
	{
		MessageBox("自增最大不能超过9。", "提示", MB_OK);
		return 1;
	}

	//check
	value = atoi(dataLength.GetBuffer());
	if (value > 64)
	{
		MessageBox("DataLength最大长度不能超过64。", "提示", MB_OK);
		return 1;
	}

	//check
	GetDlgItem(IDC_EDIT_PREFIX)->GetWindowText(prefix);
	if (prefix.GetLength() > 64)
	{
		MessageBox("前缀最大长度不能超过64。", "提示", MB_OK);
		return 1;
	}
	
	m_addMode = addMode;
	m_dataLength = dataLength;
	m_prefix = prefix;
	SaveConfig();
	return 0;
}

int WriteSetTabDlg::SetData()
{
	GetDlgItem(IDC_EDIT_DATA_LENGHT)->SetWindowText(m_dataLength);
	GetDlgItem(IDC_EDIT_ADD)->SetWindowText(m_addMode);
	GetDlgItem(IDC_EDIT_PREFIX)->SetWindowText(m_prefix);
	return 0;
}

void WriteSetTabDlg::SaveConfig()
{
	std::string strValue;
	strValue = m_magic.GetBuffer();
	//m_iniConfig.SetStringValue("vendor", "magic", strValue);

	strValue = m_dataLength.GetBuffer();
	m_iniConfig.SetStringValue("vendor", "dataLength", strValue);

	strValue = m_prefix.GetBuffer();
	m_iniConfig.SetStringValue("vendor", "prefix", strValue);

	strValue = m_addMode.GetBuffer();
	m_iniConfig.SetStringValue("vendor", "addMode", strValue);
	m_iniConfig.Save();
}
void WriteSetTabDlg::OnOK()
{

}

void WriteSetTabDlg::OnEnChangeEditPrefix()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	//CString strValue;
	//GetDlgItem(IDC_EDIT_PREFIX)->GetWindowText(strValue);
	//if (strValue.GetLength() > 64)
	//{
	//	strValue = strValue.Left(64);
	//	MessageBox("长度不能超过64。", "提示", MB_OK);
	//	GetDlgItem(IDC_EDIT_PREFIX)->SetWindowText(strValue);
	//}
	//else
	//{
	//	m_prefix = strValue;
	//}
	
}


void WriteSetTabDlg::OnEnChangeEditDataLenght()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码
	//CString strValue;
	//GetDlgItem(IDC_EDIT_DATA_LENGHT)->GetWindowText(strValue);
	//int value = atoi(strValue.GetBuffer());
	//if (value > 64)
	//{
	//	MessageBox("最大长度不能超过64。", "提示", MB_OK);
	//	GetDlgItem(IDC_EDIT_DATA_LENGHT)->SetWindowText("64");
	//}
	//else
	//{
	//	m_dataLength = strValue;
	//}
}


void WriteSetTabDlg::OnEnChangeEditAdd()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码

	//CString strValue;
	//GetDlgItem(IDC_EDIT_ADD)->GetWindowText(strValue);
	//int value = atoi(strValue.GetBuffer());
	//if (value > 9)
	//{
	//	MessageBox("最大不能超过9。", "提示", MB_OK);
	//	GetDlgItem(IDC_EDIT_ADD)->SetWindowText(m_addMode);
	//}
	//else
	//{
	//	m_addMode = strValue;
	//}
}
