﻿// WriteSetTabCommonDlg.cpp: 实现文件
//

#include "pch.h"
#include "resource.h"
#include "WriteSetTabCommonDlg.h"
#include "afxdialogex.h"


// WriteSetTabCommonDlg 对话框

IMPLEMENT_DYNAMIC(WriteSetTabCommonDlg, CDialogEx)

WriteSetTabCommonDlg::WriteSetTabCommonDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DIALOG_TAB_SET_COMMON, pParent)
{

}

WriteSetTabCommonDlg::~WriteSetTabCommonDlg()
{
}

void WriteSetTabCommonDlg::Init(ENUM_SET_TYPE eSetType)
{
    m_eSetType = eSetType;
    char path[MAX_PATH];
    GetModuleFileName(0, path, MAX_PATH);
    PathRemoveFileSpec(path);
    std::string fileName = "Config.ini";

    m_iniConfig.Load(std::string(path) + "\\Config\\" + fileName);
    std::string strValue;
    m_iniConfig.GetStringValue("vendor", "magic", &strValue);
    m_magic = strValue.c_str();

    //
    GetDlgItem(IDC_EDIT_MAGIC)->SetWindowText(m_magic);

}

void WriteSetTabCommonDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


void  WriteSetTabCommonDlg::GetSetConfigData(USBSetCommonData& usbData)
{
    usbData.magic = m_magic;
}
void  WriteSetTabCommonDlg::SaveConfig()
{
    std::string strValue = m_magic.GetBuffer();
    m_iniConfig.SetStringValue("vendor", "magic", strValue);
    m_iniConfig.Save();

}
int   WriteSetTabCommonDlg::UpdateData()
{
    CString magic;
    GetDlgItem(IDC_EDIT_MAGIC)->GetWindowText(magic);
    if (magic.GetLength() > 16)
    {
        MessageBox("Magic 最大长度不能超过16!", "提示", MB_OK);
        return 1;
    }

    m_magic = magic;
    return 0;
}
int   WriteSetTabCommonDlg::SetData()
{
    GetDlgItem(IDC_EDIT_MAGIC)->SetWindowText(m_magic);
    return 0;
}

void WriteSetTabCommonDlg::OnOK()
{

}


BEGIN_MESSAGE_MAP(WriteSetTabCommonDlg, CDialogEx)
END_MESSAGE_MAP()


// WriteSetTabCommonDlg 消息处理程序


BOOL WriteSetTabCommonDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    // TODO:  在此添加额外的初始化


    return TRUE;  // return TRUE unless you set the focus to a control
                  // 异常: OCX 属性页应返回 FALSE
}
