﻿// WriteSetDlg.cpp: 实现文件
//

#include "pch.h"
#include "resource.h"
#include "WriteSetDlg.h"
#include "afxdialogex.h"
#include <vector>
#include "WriteToolDlg.h"

// WriteSetDlg 对话框

IMPLEMENT_DYNAMIC(WriteSetDlg, CDialogEx)

WriteSetDlg::WriteSetDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DIALOG_SET, pParent)
{

}

WriteSetDlg::~WriteSetDlg()
{
}

void WriteSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_SET, m_tab);
}


BEGIN_MESSAGE_MAP(WriteSetDlg, CDialogEx)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_SET, &WriteSetDlg::OnTcnSelchangeTabSet)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON1_OK, &WriteSetDlg::OnBnClickedButton1Ok)
	ON_BN_CLICKED(IDC_BUTTON1_CANCEL, &WriteSetDlg::OnBnClickedButton1Cancel)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()


// WriteSetDlg 消息处理程序


BOOL WriteSetDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  在此添加额外的初始化
	//init tabControl;
	m_tab.InsertItem(E_SEC_SN, "SN");
	m_tab.InsertItem(E_SEC_MAC, "MAC");
	m_tab.InsertItem(E_SEC_DID, "DID");
	m_tab.InsertItem(E_SEC_KEY, "KEY");
	m_tab.InsertItem(E_SEC_SSID, "SSID");
	m_tab.InsertItem(E_SEC_RESERVE_0, "RESERVE0");
	m_tab.InsertItem(E_SEC_RESERVE_1, "RESERVE1");
	m_tab.InsertItem(E_SEC_RESERVE_2, "RESERVE2");
    m_tab.InsertItem(E_SEC_RESERVE_2 + 1, "COMMON");
	m_tab.SetCurSel(0);

	CRect rect;
	m_tab.GetClientRect(&rect);
	rect.left += 1;
	rect.right -= 1;
	rect.top += 20;
	rect.bottom -= 1;

	//init sn setdlg
	m_snSetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_snSetDlg.ShowWindow(SW_SHOW);
	m_snSetDlg.MoveWindow(rect);
	m_snSetDlg.Init(E_SEC_SN);

	//int MAC
	m_macSetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_macSetDlg.ShowWindow(SW_HIDE);
	m_macSetDlg.MoveWindow(rect);
	m_macSetDlg.Init(E_SEC_MAC);

	//init DID
	m_didSetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_didSetDlg.ShowWindow(SW_HIDE);
	m_didSetDlg.MoveWindow(rect);
	m_didSetDlg.Init(E_SEC_DID);

	//INIT KEY
	m_keySetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_keySetDlg.ShowWindow(SW_HIDE);
	m_keySetDlg.MoveWindow(rect);
	m_keySetDlg.Init(E_SEC_KEY);

	//INIT  SSID
	m_ssidSetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_ssidSetDlg.ShowWindow(SW_HIDE);
	m_ssidSetDlg.MoveWindow(rect);
	m_ssidSetDlg.Init(E_SEC_SSID);

	//INIT reserve1
	m_reserve0SetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_reserve0SetDlg.ShowWindow(SW_HIDE);
	m_reserve0SetDlg.MoveWindow(rect);
	m_reserve0SetDlg.Init(E_SEC_RESERVE_0);

	//INIT RES
	m_reserve1SetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_reserve1SetDlg.ShowWindow(SW_HIDE);
	m_reserve1SetDlg.MoveWindow(rect);
	m_reserve1SetDlg.Init(E_SEC_RESERVE_1);

	m_reserve2SetDlg.Create(IDD_DIALOG_TAB_SET, &m_tab);
	m_reserve2SetDlg.ShowWindow(SW_HIDE);
	m_reserve2SetDlg.MoveWindow(rect);
	m_reserve2SetDlg.Init(E_SEC_RESERVE_2);

    //common
    m_commonSetDlg.Create(IDD_DIALOG_TAB_SET_COMMON, &m_tab);
    m_commonSetDlg.ShowWindow(SW_HIDE);
    m_commonSetDlg.MoveWindow(rect);
    m_commonSetDlg.Init((ENUM_SET_TYPE)(E_SEC_RESERVE_2 + 1));

	return TRUE;  // return TRUE unless you set the focus to a control
				  // 异常: OCX 属性页应返回 FALSE
}


void WriteSetDlg::OnTcnSelchangeTabSet(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: 在此添加控件通知处理程序代码
	*pResult = 0;
	int curSel = m_tab.GetCurSel();
	std::vector<CWnd*> tabs;
	tabs.push_back(&m_snSetDlg);
	tabs.push_back(&m_macSetDlg);
	tabs.push_back(&m_didSetDlg);
	tabs.push_back(&m_keySetDlg);
	tabs.push_back(&m_ssidSetDlg);
	tabs.push_back(&m_reserve0SetDlg);
	tabs.push_back(&m_reserve1SetDlg);
	tabs.push_back(&m_reserve2SetDlg);
    tabs.push_back(&m_commonSetDlg);
	for (int i = 0; i < tabs.size(); i++)
	{
		if (curSel == i)
		{
			tabs[i]->ShowWindow(SW_SHOW);
		}
		else
		{
			tabs[i]->ShowWindow(SW_HIDE);
		}
	}
}

void WriteSetDlg::GetSetConfigData(int eSetType, USBSetData &usbData)
{
	switch (eSetType)
	{
	case E_SEC_SN:
		m_snSetDlg.GetSetConfigData(usbData);
		break;
	case E_SEC_MAC:
		m_macSetDlg.GetSetConfigData(usbData);
		break;
	case E_SEC_DID:
		m_didSetDlg.GetSetConfigData(usbData);
		break;
	case E_SEC_KEY:
		m_keySetDlg.GetSetConfigData(usbData);
		break;
	case E_SEC_SSID:
		m_ssidSetDlg.GetSetConfigData(usbData);
		break;
	case E_SEC_RESERVE_0:
		m_reserve0SetDlg.GetSetConfigData(usbData);
		break;
	case E_SEC_RESERVE_1:
		m_reserve1SetDlg.GetSetConfigData(usbData);
		break;
	case E_SEC_RESERVE_2:
		m_reserve2SetDlg.GetSetConfigData(usbData);
		break;

	}
}

void WriteSetDlg::GetSetCommonConfigData(USBSetCommonData &usbData)
{
    m_commonSetDlg.GetSetConfigData(usbData);
}


void WriteSetDlg::OnClose()
{
	// TODO: 在此添加消息处理程序代码和/或调用默认值
	CDialogEx::OnClose();
}
void WriteSetDlg::OnOK()
{
	//CDialogEx::OnOK();
}

void WriteSetDlg::OnBnClickedButton1Ok()
{
	// TODO: 在此添加控件通知处理程序代码
	if (m_snSetDlg.UpdateData() != 0)
	{
		return;
	}
	if (m_macSetDlg.UpdateData() != 0)
	{
		return;
	}
	if (m_didSetDlg.UpdateData() != 0)
	{
		return;
	}
	if (m_keySetDlg.UpdateData() != 0)
	{
		return;
	}
	if (m_ssidSetDlg.UpdateData() != 0)
	{
		return;
	}
	if (m_reserve0SetDlg.UpdateData() != 0)
	{
		return;
	}
	if (m_reserve1SetDlg.UpdateData() != 0)
	{
		return;
	}
	if (m_reserve2SetDlg.UpdateData() != 0)
	{
		return;
	}
    if (m_commonSetDlg.UpdateData() != 0)
    {
        return ;
    }

	ShowWindow(SW_HIDE);
	::PostMessage(WriteToolDlg::GetInstance()->m_hWnd, WM_SELF_CONFG_CHAGE, 0, 0);

}


void WriteSetDlg::OnBnClickedButton1Cancel()
{
	// TODO: 在此添加控件通知处理程序代码
	ShowWindow(SW_HIDE);
}



void WriteSetDlg::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialogEx::OnShowWindow(bShow, nStatus);

	// TODO: 在此处添加消息处理程序代码
	if (bShow)
	{
		m_snSetDlg.SetData();
		m_macSetDlg.SetData();
		m_didSetDlg.SetData();
		m_keySetDlg.SetData();
		m_ssidSetDlg.SetData();
		m_reserve0SetDlg.SetData();
		m_reserve1SetDlg.SetData();
		m_reserve2SetDlg.SetData();
        m_commonSetDlg.SetData();
	}
}
