﻿
// USBhotplugDlg.h: 头文件
//

#pragma once
#include "usb/uvcview.h"
#include<map>
#include<vector>



struct tagListData
{
	CString strUsbPort; 
	CString strUsbDeviceId;
	CString strUsbDriver;
	CString strUsbDesc;
};

struct tagWriteADB
{
	int vid;
	int pid;
};
// 用于应用程序“关于”菜单项的 CAboutDlg 对话框

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnNMThemeChangedCheckAll(NMHDR *pNMHDR, LRESULT *pResult);
	virtual BOOL OnInitDialog();
};


// CUSBhotplugDlg 对话框
class CUSBhotplugDlg : public CDialogEx
{
// 构造
public:
	CUSBhotplugDlg(CWnd* pParent = nullptr);	// 标准构造函数
	virtual ~CUSBhotplugDlg();
// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_USBHOTPLUG_DIALOG };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV 支持
public:
	//USERVIEW
	HINSTANCE       m_hInstance = NULL;
	HWND            m_hMainWnd = NULL;
	HWND            m_hTreeWnd = NULL;
	HWND            m_hEditWnd = NULL;
	HWND            m_hStatusWnd = NULL;
	HMENU           m_hMainMenu = NULL;
	HTREEITEM       m_hTreeRoot = NULL;
	HCURSOR         m_hSplitCursor = NULL;
	HDEVNOTIFY      m_NotifyDevHandle = NULL;
	HDEVNOTIFY      m_NotifyHubHandle = NULL;
	HANDLE          m_hStdOut = NULL;

	BOOL            m_bConsoleFile = FALSE;
	BOOL            m_bConsoleInitialized = FALSE;
	BOOL            m_gbButtonDown = FALSE;
	BOOL            m_DoAutoRefresh = TRUE;

	int             m_BarLocation = 0;
	int             m_iGoodDevice = 0;
	int             m_iBadDevice = 0;
	int             m_iComputer = 0;
	int             m_iHub = 0;
	int             m_iNoDevice = 0;
	int             m_iGoodSsDevice = 0;
	int             m_iNoSsDevice = 0;

	std::map<CString, tagListData> m_ListData;
	CListCtrl       m_listCtrl;
	CFont			m_listFont;
	int             m_start;
	CString         m_userPath;

public:
	void InitUSBViewTree();
	HTREEITEM  AddLeaf(HTREEITEM hTreeParent, LPARAM    lParam, _In_ LPTSTR    lpszText, TREEICON  TreeIcon);
	void RefreshTree();
	void DestroyTree();
	void WalkTree(_In_ HTREEITEM hTreeItem, _In_ LPFNTREECALLBACK lpfnTreeCallback, _In_opt_ PVOID  pContext);
	void AddConnectionPort( CString strUsbPort, CString strUsbDeviceId, CString strUsbDriver, CString strUsbDesc );
	void DeleteConnectionPort(CString strUsbDeviceId);


	void RefreshListControl();
	void InitListControl();
	void WriteToFile(std::vector<CString> pids);


	LRESULT DeviceChange(UINT message, WPARAM wParam, LPARAM lParam);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual void OnOK();
	void UpgrateADB();

public:
	static CUSBhotplugDlg *m_instance;
	static CUSBhotplugDlg *GetInstance() { return m_instance; }

// 实现
protected:
	HICON m_hIcon;

	// 生成的消息映射函数
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButton2Start();
	afx_msg void OnBnClickedButton1Stop();
	afx_msg void OnEnChangeEdit2();
};
