﻿
// USBhotplugDlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "USBhotplug.h"
#include "USBhotplugDlg.h"
#include "afxdialogex.h"
#include "DriverInstall.h"
#include "./Log/logger.h"


#include "usb/uvcview.h"
#include "usb/h264.h"
#include "WriteToolDlg.h"
extern DEVICE_GUID_LIST gHubList;
extern DEVICE_GUID_LIST gDeviceList;
extern DEVICE_GUID_LIST gDiskList;


#ifdef _DEBUG
#define new DEBUG_NEW
#endif




CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}
BOOL CAboutDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  在此添加额外的初始化

	
	GetDlgItem(IDC_STATIC_TITLE)->SetWindowText(WriteToolDlg::GetInstance()->m_appTitle);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // 异常: OCX 属性页应返回 FALSE
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
	ON_NOTIFY(NM_THEMECHANGED, IDC_CHECK_ALL, &CAboutDlg::OnNMThemeChangedCheckAll)
END_MESSAGE_MAP()


// CUSBhotplugDlg 对话框


/*****************************************************************************

AddLeaf()

*****************************************************************************/

HTREEITEM
AddLeaf(
	HTREEITEM hTreeParent,
	LPARAM    lParam,
	_In_ LPTSTR    lpszText,
	TREEICON  TreeIcon
)
{
	return CUSBhotplugDlg::GetInstance()->AddLeaf(hTreeParent, lParam, lpszText, TreeIcon);
}


void  AddConnectionPort(

	_In_ LPTSTR lpszUsbPort,
	_In_ LPTSTR lpszUsbDeviceId,
	_In_ LPTSTR lpszUsbDriver,
	_In_ LPTSTR lpszUsbDesc
)
{
	CUSBhotplugDlg::GetInstance()->AddConnectionPort(lpszUsbPort, lpszUsbDeviceId, lpszUsbDriver, lpszUsbDesc);
}



CUSBhotplugDlg *CUSBhotplugDlg::m_instance = 0;

CUSBhotplugDlg::CUSBhotplugDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_USBHOTPLUG_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_instance = this;
}

CUSBhotplugDlg::~CUSBhotplugDlg()
{
	
}

void CUSBhotplugDlg::DoDataExchange(CDataExchange* pDX)
{

	
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_listCtrl);
}

BEGIN_MESSAGE_MAP(CUSBhotplugDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2_START, &CUSBhotplugDlg::OnBnClickedButton2Start)
	ON_BN_CLICKED(IDC_BUTTON1_STOP, &CUSBhotplugDlg::OnBnClickedButton1Stop)
	ON_EN_CHANGE(IDC_EDIT2, &CUSBhotplugDlg::OnEnChangeEdit2)
END_MESSAGE_MAP()


// CUSBhotplugDlg 消息处理程序

BOOL CUSBhotplugDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	//ShowWindow(SW_MINIMIZE);

	// TODO: 在此添加额外的初始化代码
	CMenu menu;
	menu.LoadMenuA(IDR_MENU1);
	SetMenu(&menu);

	CString sPath;

	SHGetFolderPath(NULL, CSIDL_PROFILE, NULL, 0, sPath.GetBuffer(MAX_PATH));
	sPath.Format("%s\\.android", sPath);
	m_userPath = sPath;
	if (PathFileExists(sPath) == false)
	{
		CreateDirectory(sPath, 0);
	}
	GetDlgItem(IDC_EDIT1)->SetWindowTextA(sPath);

	sPath.ReleaseBuffer();

	GetDlgItem(IDC_EDIT2)->SetWindowTextA("ADB");
	//((CButton *)GetDlgItem(IDC_CHECK1))->SetCheck(1);

	//CHANGE UI STATE
	OnBnClickedButton1Stop();
	InitListControl();
	InitUSBViewTree();





	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CUSBhotplugDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CUSBhotplugDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CUSBhotplugDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CUSBhotplugDlg::InitUSBViewTree()
{
	HIMAGELIST                      himl;
	HICON                           hicon;
	DEV_BROADCAST_DEVICEINTERFACE   broadcastInterface;



	// Register to receive notification when a USB device is plugged in.
	broadcastInterface.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
	broadcastInterface.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;

	memcpy(&(broadcastInterface.dbcc_classguid),
		&(GUID_DEVINTERFACE_USB_DEVICE),
		sizeof(struct _GUID));

	m_NotifyDevHandle = RegisterDeviceNotification(m_hWnd,
		&broadcastInterface,
		DEVICE_NOTIFY_WINDOW_HANDLE);

	// Now register for Hub notifications.
	memcpy(&(broadcastInterface.dbcc_classguid),
		&(GUID_CLASS_USBHUB),
		sizeof(struct _GUID));

	m_NotifyDevHandle = RegisterDeviceNotification(m_hWnd,
		&broadcastInterface,
		DEVICE_NOTIFY_WINDOW_HANDLE);


	gHubList.DeviceInfo = INVALID_HANDLE_VALUE;
	InitializeListHead(&gHubList.ListHead);
	gDeviceList.DeviceInfo = INVALID_HANDLE_VALUE;
	InitializeListHead(&gDeviceList.ListHead);

	gDiskList.DeviceInfo = INVALID_HANDLE_VALUE;
	InitializeListHead(&gDiskList.ListHead);
	//end add

	m_hTreeWnd = GetDlgItem(IDC_TREE_USBVIEW)->m_hWnd;

	//added
	if ((himl = ImageList_Create(15, 15,
		FALSE, 2, 0)) == NULL)
	{
		OOPS();
	}

	m_hInstance = AfxGetInstanceHandle();
	if (himl != NULL)
	{
		hicon = LoadIcon(m_hInstance, MAKEINTRESOURCE(IDI_ICON_USB));
		m_iGoodDevice = ImageList_AddIcon(himl, hicon);

		hicon = LoadIcon(m_hInstance, MAKEINTRESOURCE(IDI_BADICON));
		m_iBadDevice = ImageList_AddIcon(himl, hicon);

		hicon = LoadIcon(m_hInstance, MAKEINTRESOURCE(IDI_COMPUTER));
		m_iComputer = ImageList_AddIcon(himl, hicon);

		hicon = LoadIcon(m_hInstance, MAKEINTRESOURCE(IDI_HUB));
		m_iHub = ImageList_AddIcon(himl, hicon);

		hicon = LoadIcon(m_hInstance, MAKEINTRESOURCE(IDI_NODEVICE));
		m_iNoDevice = ImageList_AddIcon(himl, hicon);

		hicon = LoadIcon(m_hInstance, MAKEINTRESOURCE(IDI_SSICON));
		m_iGoodSsDevice = ImageList_AddIcon(himl, hicon);

		hicon = LoadIcon(m_hInstance, MAKEINTRESOURCE(IDI_NOSSDEVICE));
		m_iNoSsDevice = ImageList_AddIcon(himl, hicon);

		TreeView_SetImageList(m_hTreeWnd, himl, TVSIL_NORMAL);
		// end add
	}

	//m_hEditWnd = GetDlgItem(IDC_EDIT_USBVIEW)->m_hWnd;
	//GetDlgItem(IDC_EDIT_USBVIEW)->ShowScrollBar(SB_VERT, SW_SHOW);
	//GetDlgItem(IDC_EDIT_USBVIEW)->ShowScrollBar(SB_HORZ, SW_SHOW);
#ifdef H264_SUPPORT
	// set the edit control to have a max text limit size
	//::SendMessage(m_hEditWnd, EM_LIMITTEXT, 0 /* USE DEFAULT MAX*/, 0);
#endif
	//ghStatusWnd = GetDlgItem(IDC_STATUS);
	//m_hMainMenu = GetMenu(hWnd);
	//if (ghMainMenu == NULL)
	//{
	//    OOPS();
	//}
	//{
	//    CHAR pszFont[256];
	//    CHAR pszHeight[8];

	//    memset(pszFont, 0, sizeof(pszFont));
	//    LoadString(ghInstance, IDS_STANDARD_FONT, pszFont, sizeof(pszFont) - 1);
	//    memset(pszHeight, 0, sizeof(pszHeight));
	//    LoadString(ghInstance, IDS_STANDARD_FONT_HEIGHT, pszHeight, sizeof(pszHeight) - 1);

	//    hFont = CreateFont((int)pszHeight[0], 0, 0, 0,
	//        400, 0, 0, 0,
	//        0, 1, 2, 1,
	//        49, pszFont);
	//}
	//SendMessage(m_hEditWnd,
	//    WM_SETFONT,
	//    (WPARAM)hFont,
	//    0);

	RefreshTree();

	//return FALSE;
}

void LOCAL_ExpandItem(HWND hTreeWnd, HTREEITEM hTreeItem, PVOID pContext)
{
	//
	// Make this node visible.
	//
	UNREFERENCED_PARAMETER(pContext);
	TreeView_Expand(hTreeWnd, hTreeItem, TVE_EXPAND);
}

void CUSBhotplugDlg::RefreshTree()
{

	//clean data
	//begin
	m_ListData.clear();

	//end


	CHAR  statusText[128];
	ULONG devicesConnected;


	// Clear the edit control
	//
	//::SetWindowText(m_hEditWnd, "");

	// Destroy the current contents of the TreeView
	//
	DestroyTree();

	// Create the root tree node
	//
	m_hTreeRoot = AddLeaf(TVI_ROOT, 0, "My Computer", ComputerIcon);

	if (m_hTreeRoot != NULL)
	{
		// Enumerate all USB buses and populate the tree
		//
		EnumerateHostControllers(m_hTreeRoot, &devicesConnected);

		//
		// Expand all tree nodes
		//
		WalkTree(m_hTreeRoot, LOCAL_ExpandItem, NULL);

		// Update Status Line with number of devices connected
		//
		memset(statusText, 0, sizeof(statusText));
		StringCchPrintf(statusText, sizeof(statusText),
#ifdef H264_SUPPORT
			"UVC Spec Version: %d.%d Version: %d.%d Devices Connected: %d   Hubs Connected: %d",
			UVC_SPEC_MAJOR_VERSION, UVC_SPEC_MINOR_VERSION, USBVIEW_MAJOR_VERSION, USBVIEW_MINOR_VERSION,
			devicesConnected, TotalHubs);
#else
			"Devices Connected: %d   Hubs Connected: %d",
			devicesConnected, TotalHubs);
#endif

		::SetWindowText(m_hStatusWnd, statusText);
	}
	else
	{
		OOPS();
	}


	//init list view
	//begin
	RefreshListControl();


	//end


}


void CUSBhotplugDlg::DestroyTree()
{
	// Clear the selection of the TreeView, so that when the tree is
	// destroyed, the control won't try to constantly "shift" the
	// selection to another item.
	//
	TreeView_SelectItem(m_hTreeWnd, NULL);

	// Destroy the current contents of the TreeView
	//
	if (m_hTreeRoot)
	{
		WalkTree(m_hTreeRoot, CleanupItem, NULL);

		TreeView_DeleteAllItems(m_hTreeWnd);

		m_hTreeRoot = NULL;
	}

	ClearDeviceList(&gDeviceList);
	ClearDeviceList(&gHubList);
}

void CUSBhotplugDlg::WalkTree(_In_ HTREEITEM hTreeItem, _In_ LPFNTREECALLBACK lpfnTreeCallback, _In_opt_ PVOID  pContext)
{
	if (hTreeItem)
	{
		// Recursively call WalkTree on the node's first child.
		//
		WalkTree(TreeView_GetChild(m_hTreeWnd, hTreeItem),
			lpfnTreeCallback,
			pContext);

		//
		// Call the lpfnCallBack on the node itself.
		//
		(*lpfnTreeCallback)(m_hTreeWnd, hTreeItem, pContext);

		//
		//
		// Recursively call WalkTree on the node's first sibling.
		//
		WalkTree(TreeView_GetNextSibling(m_hTreeWnd, hTreeItem),
			lpfnTreeCallback,
			pContext);
	}
}

HTREEITEM  CUSBhotplugDlg::AddLeaf(HTREEITEM hTreeParent, LPARAM    lParam,  LPTSTR    lpszText, TREEICON  TreeIcon)
{
	//////////////////////////////////////////////////////////////////
	CString strInfo = lpszText;
	int idx = strInfo.Find(": ");
	if (idx != -1)
	{
		int k = 0;
		k++;
	}

	//////////////////////////////////////////////////////////////////


	TV_INSERTSTRUCT tvins;
	HTREEITEM       hti;

	memset(&tvins, 0, sizeof(tvins));

	// Set the parent item
	//
	tvins.hParent = hTreeParent;

	tvins.hInsertAfter = TVI_LAST;

	// pszText and lParam members are valid
	//
	tvins.item.mask = TVIF_TEXT | TVIF_PARAM;

	// Set the text of the item.
	//
	tvins.item.pszText = lpszText;

	// Set the user context item
	//
	tvins.item.lParam = lParam;

	// Add the item to the tree-view control.
	//
	hti = TreeView_InsertItem(m_hTreeWnd, &tvins);

	// added
	tvins.item.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvins.item.hItem = hti;

	// Determine which icon to display for the device
	//
	switch (TreeIcon)
	{
	case ComputerIcon:
		tvins.item.iImage = m_iComputer;
		tvins.item.iSelectedImage = m_iComputer;
		break;

	case HubIcon:
		tvins.item.iImage = m_iHub;
		tvins.item.iSelectedImage = m_iHub;
		break;

	case NoDeviceIcon:
		tvins.item.iImage = m_iNoDevice;
		tvins.item.iSelectedImage = m_iNoDevice;
		break;

	case GoodDeviceIcon:
		tvins.item.iImage = m_iGoodDevice;
		tvins.item.iSelectedImage = m_iGoodDevice;
		break;

	case GoodSsDeviceIcon:
		tvins.item.iImage = m_iGoodSsDevice;
		tvins.item.iSelectedImage = m_iGoodSsDevice;
		break;

	case NoSsDeviceIcon:
		tvins.item.iImage = m_iNoSsDevice;
		tvins.item.iSelectedImage = m_iNoSsDevice;
		break;

	case BadDeviceIcon:
	default:
		tvins.item.iImage = m_iBadDevice;
		tvins.item.iSelectedImage = m_iBadDevice;
		break;
	}
	TreeView_SetItem(m_hTreeWnd, &tvins.item);

	return hti;
}


void GetUSBPidVid00(CString devicePath, int &pid, int &vid)
{
	char *endptr = 0;
	int vidfind = devicePath.Find("VID_");
	CString strVid = "0x" + devicePath.Mid(vidfind + 4, 4);
	vid = strtol(strVid.GetBuffer(), &endptr, 16);

	endptr = 0;
	int pidfind = devicePath.Find("PID_");
	CString strPid = "0x" + devicePath.Mid(pidfind + 4, 4);
	pid = strtol(strPid.GetBuffer(), &endptr, 16);
}



void  CUSBhotplugDlg::AddConnectionPort(CString strUsbPort, CString strUsbDeviceId, CString strUsbDriver, CString strUsbDesc)
{



	if (m_ListData.size() > 0)
		return ;
	
	tagListData data;
	data.strUsbPort = strUsbPort;
	data.strUsbDeviceId = strUsbDeviceId;
	data.strUsbDriver = strUsbDriver;
	data.strUsbDesc = strUsbDesc;
	m_ListData.insert(std::pair<CString, tagListData>(strUsbPort, data));

	//note
	CString strMsg;
	strMsg.Format("插入：%s %s", data.strUsbDesc, data.strUsbDriver);
	logger::record.writeLog(logger::Level::Warning, strMsg.GetBuffer());

	//
	WriteToolDlg::GetInstance()->SetStatusBarText(0, "设备连接: " + data.strUsbDesc);
	WriteToolDlg::GetInstance()->SetDiskLetter(data.strUsbDriver);
}

void CUSBhotplugDlg::DeleteConnectionPort(CString strUsbDeviceId)
{
	std::map<CString, tagListData>::iterator iter;
	for (iter = m_ListData.begin(); iter != m_ListData.end(); iter++)
	{
		if (iter->second.strUsbDeviceId == strUsbDeviceId)
		{	
			//note
			CString strMsg;
			strMsg.Format("拔出：%s %s", iter->second.strUsbDesc, iter->second.strUsbDriver);
			logger::record.writeLog(logger::Level::Warning, strMsg.GetBuffer());

			WriteToolDlg::GetInstance()->SetStatusBarText(0, "设备连接: 无");
			WriteToolDlg::GetInstance()->SetDiskLetter("");

			m_ListData.erase(iter++);
			break;
		}
		else
		{
			iter++;
		}
	}
}


void CUSBhotplugDlg::InitListControl()
{

	m_listFont.CreatePointFont(120, _T("宋体"));

	m_listCtrl.SetFont(&m_listFont);

	DWORD dwStyle = m_listCtrl.GetExtendedStyle();
	dwStyle = dwStyle | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES/* | LVS_EX_CHECKBOXES*/;
	//LVS_EX_HEADERDRAGDROP | LVS_EX_SUBITEMIMAGES;
	//选择整行 | 绘制表格 | 复选框 | 项目头可拖拽 | 图标列表
	m_listCtrl.SetExtendedStyle(dwStyle);
	m_listCtrl.InsertColumn(0, _T("Port"), LVCFMT_LEFT, 80);
	m_listCtrl.InsertColumn(1, _T("Description"), LVCFMT_LEFT, 2000);
	m_listCtrl.ShowScrollBar(SB_HORZ, 1);
}




void CUSBhotplugDlg::RefreshListControl()
{
	m_listCtrl.DeleteAllItems();
	int idx = 0;
	std::map<CString, tagListData>::iterator iter;
	std::vector<CString> pids;
	CString strName;
	GetDlgItemTextA(IDC_EDIT2, strName);



	CString tmp;
	for (iter = m_ListData.begin(); iter != m_ListData.end(); iter++)
	{
		if (strName.GetLength() != 0)
		{
			int idx = iter->second.strUsbDesc.Find(strName);
			if (idx == -1)
			{
				continue;
			}
		}

		int pid = 0, vid = 0;
		GetUSBPidVid00(iter->second.strUsbDeviceId, pid, vid);
		tmp.Format("0x%04X", vid);
		pids.push_back(tmp);


		CString desc = iter->second.strUsbDesc + "(" + iter->second.strUsbDeviceId + ")" + " " + iter->second.strUsbDriver;
		m_listCtrl.InsertItem(idx, iter->second.strUsbPort);
		m_listCtrl.SetItemText(idx, 0, iter->second.strUsbPort);
		m_listCtrl.SetItemText(idx, 1, desc);


	}

	if (m_start == 1)
	{
		WriteToFile(pids);
	}
}

void CUSBhotplugDlg::OnBnClickedButton2Start()
{
	// TODO: 在此添加控件通知处理程序代码
	//CHANGE UI STATE
	GetDlgItem(IDC_EDIT2)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON2_START)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON1_STOP)->EnableWindow(true);
	GetDlgItem(IDC_CHECK1)->EnableWindow(false);
	
	m_start = 1;

	RefreshListControl();
	::PostMessage(DriverInstall::GetInstance()->m_hWnd,WM_SELF_ADBUPDATE_OK, 0, 0);

}


void CUSBhotplugDlg::OnBnClickedButton1Stop()
{
	// TODO: 在此添加控件通知处理程序代码
	m_start = 0;

	//CHANGE UI STATE
	GetDlgItem(IDC_EDIT2)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON2_START)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON1_STOP)->EnableWindow(false);
	GetDlgItem(IDC_CHECK1)->EnableWindow(true);

}

void CUSBhotplugDlg::WriteToFile(std::vector<CString> pids)
{

	pids.clear();
	pids.push_back("0x1D6B");

	//获取文件中内容
	CString filePath = m_userPath + "\\adb_usb.ini";
	FILE *pf = fopen(filePath.GetBuffer(), "r+");
	if (!pf)
	{
		pf = fopen(filePath.GetBuffer(), "w+");
		if (!pf)
		{
			return;
		}
	}

	std::vector<CString > srcPids;
	char buf[1024] = {};
	while (fgets(buf, 1024, pf) != 0)
	{
		CString t = buf;
		t.Trim();
		srcPids.push_back(t);
	}
	fclose(pf);

	////检测
	std::vector<CString > decPids;
	std::vector<CString > decExist;
	int find =0;
	for (int i = 0; i < pids.size(); i++)
	{
		find = 0;
		for (int j = 0; j < srcPids.size(); j++)
		{
			if (srcPids[j] == pids[i])
			{
				find = 1;
				break;
			}
		}
		if (find == 0)
		{
			decPids.push_back(pids[i]);
		}
		else
		{
			decExist.push_back(pids[i]);
		}
	}


	
	
	//重新写入
	pf = fopen(filePath.GetBuffer(), "w+");
	int state = ((CButton *)GetDlgItem(IDC_CHECK1))->GetCheck();
	if (state == 1)
	{
		srcPids.clear();
		for (int i = 0; i < decExist.size(); i++)  decPids.push_back(decExist[i]);
	}

	for (int i = 0; i < decPids.size(); i++)
		srcPids.push_back(decPids[i]);
	
	CString data;
	for (int i = 0; i < srcPids.size(); i++)
	{
		data = srcPids[i] + "\n";
		fputs(data.GetBuffer(), pf);
	}
	fclose(pf);

}


LRESULT CUSBhotplugDlg::DeviceChange(UINT message, WPARAM wParam, LPARAM lParam)
{
	if (DBT_DEVICEARRIVAL == wParam || DBT_DEVICEREMOVECOMPLETE == wParam)
	{
		PDEV_BROADCAST_HDR pHdr = (PDEV_BROADCAST_HDR)lParam;
		PDEV_BROADCAST_DEVICEINTERFACE pDevInf;
		PDEV_BROADCAST_HANDLE pDevHnd;
		PDEV_BROADCAST_OEM pDevOem;
		PDEV_BROADCAST_PORT pDevPort;
		PDEV_BROADCAST_VOLUME pDevVolume;

		if (DBT_DEVICEARRIVAL == wParam)
		{
			switch (pHdr->dbch_devicetype)
			{
			case DBT_DEVTYP_DEVICEINTERFACE:
			{
				//获取DeviceId
				pDevInf = (PDEV_BROADCAST_DEVICEINTERFACE)pHdr;
				CString szDevId = pDevInf->dbcc_name + 4;
				int idx = szDevId.ReverseFind(_T('#'));
				szDevId.Truncate(idx);
				szDevId.Replace(_T('#'), _T('\\'));
				szDevId.MakeUpper();


				RefreshTree();

				//log("", "DBT_DEVTYP_DEVICEINTERFACE: 插入 %s", szDevId.GetBuffer());

				//                    log("", "DBT_DEVTYP_DEVICEINTERFACE: 插入");
				//                    USBVIEW_RefreshTree();
				//
				//                    //如果检测到有插入，直接更新
				//                    if (m_start == 1)
				//                    {
				//                        USBUPDATE_Update();
				//                    }
			}
			break;

			case DBT_DEVTYP_HANDLE:
				pDevHnd = (PDEV_BROADCAST_HANDLE)pHdr;
				break;

			case DBT_DEVTYP_OEM:
				pDevOem = (PDEV_BROADCAST_OEM)pHdr;
				break;

			case DBT_DEVTYP_PORT:
				pDevPort = (PDEV_BROADCAST_PORT)pHdr;
				break;

			case DBT_DEVTYP_VOLUME:
			{

				//pDevVolume = (PDEV_BROADCAST_VOLUME)pHdr;
				//int l = (int)(log(double(pDevVolume->dbcv_unitmask)) / log(double(2)));
				//CString userPath;
				//userPath.Format("%c:/", 'A' + l);
				//log("", "%s: 插入", userPath.GetBuffer());

				//USBVIEW_RefreshTree();
				////如果检测到有插入，直接更新
				//if (m_start == 1)
				//{
				//	USBUPDATE_Update();
				//}
			}

			break;

			}
		}
		else if (DBT_DEVICEREMOVECOMPLETE == wParam)
		{
			switch (pHdr->dbch_devicetype)
			{
			case DBT_DEVTYP_DEVICEINTERFACE:
			{

				
				//pDevInf = (PDEV_BROADCAST_DEVICEINTERFACE)pHdr;
				////获取DeviceId
				pDevInf = (PDEV_BROADCAST_DEVICEINTERFACE)pHdr;
				CString szDevId = pDevInf->dbcc_name + 4;
				int idx = szDevId.ReverseFind(_T('#'));
				szDevId.Truncate(idx);
				szDevId.Replace(_T('#'), _T('\\'));
				szDevId.MakeUpper();

				DeleteConnectionPort(szDevId);

				RefreshTree();
				

				//log("", "DBT_DEVTYP_DEVICEINTERFACE: 拔出 %s", szDevId.GetBuffer());

				////                    log("", "DBT_DEVTYP_DEVICEINTERFACE: 拔出");
				////                    //更新树数据
				////                    USBVIEW_RefreshTree();
			}
			break;

			case DBT_DEVTYP_HANDLE:
				pDevHnd = (PDEV_BROADCAST_HANDLE)pHdr;
				break;

			case DBT_DEVTYP_OEM:
				pDevOem = (PDEV_BROADCAST_OEM)pHdr;
				break;

			case DBT_DEVTYP_PORT:
				pDevPort = (PDEV_BROADCAST_PORT)pHdr;
				break;

			case DBT_DEVTYP_VOLUME:
			{
				//pDevVolume = (PDEV_BROADCAST_VOLUME)pHdr;
				//int l = (int)(log(double(pDevVolume->dbcv_unitmask)) / log(double(2)));
				//CString userPath;
				//userPath.Format("%c:/", 'A' + l);
				//log("", "%s: 拔出", userPath.GetBuffer());

				////UVC升级完没有重启，通过拔出事件进行删除
				//if (m_UVCMode == 1)
				//{
				//	USBVIEW_DeleteUsbInfo(userPath);
				//}

				////更新树数据
				//USBVIEW_RefreshTree();
			}
			break;
			}
		}

	}
	return true;
}

LRESULT CUSBhotplugDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_DEVICECHANGE:


		DeviceChange(message, wParam, lParam);
		break;
	}

	return CWnd::WindowProc(message, wParam, lParam);
}

void CUSBhotplugDlg::OnOK()
{

}

void CUSBhotplugDlg::OnEnChangeEdit2()
{
	// TODO:  如果该控件是 RICHEDIT 控件，它将不
	// 发送此通知，除非重写 CDialogEx::OnInitDialog()
	// 函数并调用 CRichEditCtrl().SetEventMask()，
	// 同时将 ENM_CHANGE 标志“或”运算到掩码中。

	// TODO:  在此添加控件通知处理程序代码

	RefreshListControl();
}

void CUSBhotplugDlg::UpgrateADB()
{
	//升级
	GetDlgItem(IDC_EDIT2)->SetWindowTextA("ADB");
	//((CButton *)GetDlgItem(IDC_CHECK1))->SetCheck(1);
	OnBnClickedButton2Start();
}


void CAboutDlg::OnNMThemeChangedCheckAll(NMHDR *pNMHDR, LRESULT *pResult)
{
	// 该功能要求使用 Windows XP 或更高版本。
	// 符号 _WIN32_WINNT 必须 >= 0x0501。
	// TODO: 在此添加控件通知处理程序代码


	int k = 0;
	k++;

	*pResult = 0;
}


