
#include <cassert>
#include <chrono>
#include <ctime>
#include <iostream>
#include <iomanip>
#include <map>
#include <regex>
#include "logger.h"
#include "../pch.h"

using namespace std;
using namespace logger;

//ConsoleLogger logger::debug;
FileLogger logger::record("log");

#ifdef WIN32
#define localtime_r(_Time, _Tm) localtime_s(_Tm, _Time)
#endif

static const map<Level, const char *> LevelStr =
{
	{ Level::Debug, "Debug" },
	{ Level::Info, "Info" },
	{ Level::Warning, "Warning" },
	{ Level::Error, "Error" },
	{ Level::Fatal, "Fatal" },
};

ostream& operator<< (ostream& stream, const tm* tm)
{

	return stream << 1900 + tm->tm_year << '-'
		<< setfill('0') << setw(2) << tm->tm_mon + 1 << '-'
		<< setfill('0') << setw(2) << tm->tm_mday << ' '
		<< setfill('0') << setw(2) << tm->tm_hour << ':'
		<< setfill('0') << setw(2) << tm->tm_min << ':'
		<< setfill('0') << setw(2) << tm->tm_sec;
}

BaseLogger::LogStream BaseLogger::operator()(Level nLevel)
{
	return LogStream(*this, nLevel);
}

const tm* BaseLogger::getLocalTime()
{
	auto now = chrono::system_clock::now();
	auto in_time_t = chrono::system_clock::to_time_t(now);
	localtime_r(&in_time_t, &_localTime);
	return &_localTime;
}

void BaseLogger::endline(Level nLevel, string&& oMessage)
{
	_lock.lock();
	output(getLocalTime(), LevelStr.find(nLevel)->second, oMessage.c_str());
	_lock.unlock();
}

void ConsoleLogger::output(const tm *p_tm,
	const char *str_level,
	const char *str_message)
{
	
	cout << '[' << p_tm << ']'
		<< '[' << str_level << "]"
		<< "\t" << str_message << endl;
	cout.flush();
}

FileLogger::FileLogger(string filename) noexcept
	: BaseLogger()
{
	const tm* p = getLocalTime();
	char buf[512];
	char szFilePath[MAX_PATH] = { 0 };
	GetModuleFileName(NULL, szFilePath, MAX_PATH);
	PathRemoveFileSpec(szFilePath);

	sprintf(buf,"%s\\Log\\%s_%d_%d_%d.log", szFilePath, filename.c_str(), p->tm_year, p->tm_mon+1, p->tm_mday);

	//string valid_filename(filename.size(), '\0');
	//regex express("/|:| |>|<|\"|\\*|\\?|\\|");
	//regex_replace(valid_filename.begin(),
	//	filename.begin(),
	//	filename.end(),
	//	express,
	//	"_");
	

	_file.open(buf,
		fstream::out | fstream::app | fstream::ate);
	bool k = _file.fail();

	assert(!_file.fail());
}

FileLogger::~FileLogger()
{
	_file.flush();
	_file.close();
}

void FileLogger::output(const tm *p_tm,
	const char *str_level,
	const char *str_message)
{
	_file << '[' << p_tm << ']'
		<< '[' << str_level << "]"
		<< "\t" << str_message << endl;
	_file.flush();
}


void FileLogger::writeLog(const Level nLevel,
	const char *str_message)
{

	ostringstream oss;
	const tm* p_tm = getLocalTime();
	oss << '[' << p_tm << ']'
		<< '[' << LevelStr.find(nLevel)->second << "]"
		<< "\t" << str_message << endl;

	if (m_cbFunc)
	{
		string dump(oss.str());
		(*m_cbFunc)((int)nLevel, dump.c_str());
	}

	_file << oss.str();
	_file.flush();
}