﻿// DriverInstall.cpp: 实现文件
//

#include "pch.h"
#include "USBhotplug.h"
#include "DriverInstall.h"
#include "afxdialogex.h"


// DriverInstall 对话框

IMPLEMENT_DYNAMIC(DriverInstall, CDialogEx)


 DriverInstall* DriverInstall::m_instance = 0;

DriverInstall::DriverInstall(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DIALOG1, pParent)
{
	m_instance = this;
}

DriverInstall::~DriverInstall()
{


}

void DriverInstall::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(DriverInstall, CDialogEx)
	ON_MESSAGE(WM_SELF_ADBUPDATE_OK, OnADBUpdateHandle)
	ON_WM_TIMER()
END_MESSAGE_MAP()


// DriverInstall 消息处理程序


BOOL DriverInstall::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  在此添加额外的初始化
	m_usbHotplugDlg.Create(IDD_USBHOTPLUG_DIALOG, NULL);
	m_usbHotplugDlg.ShowWindow(SW_HIDE);
	//m_curAppPath = GetWorkDir();


	TCHAR szFilePath[MAX_PATH] = { 0 };
	GetModuleFileName(NULL, szFilePath, MAX_PATH);
	PathRemoveFileSpec(szFilePath);
	m_curAppPath = szFilePath;

	ExecuteCmd("cmd.exe  /c  " +  m_curAppPath + "\\" + "Driver\\server.bat > " + m_curAppPath + "\\Log\\log.txt");


	SetTimer(1, 5000,NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // 异常: OCX 属性页应返回 FALSE
}


LRESULT DriverInstall::OnADBUpdateHandle(WPARAM wParam, LPARAM lParam)
{
	
	CDialogEx::OnOK();
	return TRUE;
}

void DriverInstall::OnTimer(UINT_PTR nIDEvent)
{
	switch (nIDEvent)
	{
	case 1:
		{
			m_usbHotplugDlg.UpgrateADB();
			KillTimer(1);
		}
		break;
	}
	CDialogEx::OnTimer(nIDEvent);
}


TCHAR* DriverInstall::StringToChar(CString& str)
{
	int len = str.GetLength();
	TCHAR* tr = str.GetBuffer(len);
	str.ReleaseBuffer();
	return tr;
}

CString DriverInstall::ExecuteCmd(CString str)
{
	SECURITY_ATTRIBUTES sa;
	HANDLE hRead, hWrite;

	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	sa.lpSecurityDescriptor = NULL;
	sa.bInheritHandle = TRUE;
	if (!CreatePipe(&hRead, &hWrite, &sa, 0))
	{
		MessageBox("Error on CreatePipe()!");
		return NULL;
	}
	STARTUPINFO si = { sizeof(si) };
	PROCESS_INFORMATION pi;
	si.hStdError = hWrite;
	si.hStdOutput = hWrite;
	si.wShowWindow = SW_HIDE;
	si.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;
	TCHAR* cmdline = StringToChar(str);
	if (!CreateProcess(NULL, cmdline, NULL, NULL, TRUE, NULL, NULL, NULL, &si, &pi))
	{
		MessageBox("Error on CreateProcess()!");
		return NULL;
	}
	CloseHandle(hWrite);

	char buffer[4096];
	memset(buffer, 0, 4096);
	CString output;
	DWORD byteRead;
	while (true)
	{
		if (ReadFile(hRead, buffer, 4095, &byteRead, NULL) == NULL)
		{
			break;
		}
		output += buffer;
	}
	return output;
}

CString DriverInstall::GetWorkDir() {
	char pFileName[MAX_PATH] = { 0 };
	int nPos = GetCurrentDirectory(MAX_PATH, pFileName);

	CString csFullPath(pFileName);
	if (nPos < 0)
		return CString("");
	else
		return csFullPath;
}
